package servercore.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

import lib.io.ByteUtil;
import servercore.http.HttpServer;
import servercore.http.HttpRequest;
import servercore.data.HtmlParam;
import servercore.job.JobWorker;

public class TcpInstance extends Thread{
	private Socket socket;
	OutputStream ops = null;
	InputStream ips = null;

	public TcpInstance(Socket sock) {

		this.socket = sock;
	}
	public void run() {
		// 接続が確立したらストリームを作成する
		try{
			//入出力ストリームを取得
			ops = socket.getOutputStream();
			ips = socket.getInputStream();
			JobWorker job = new JobWorker();

			job.execute(ops, ips);

		} catch(Exception e){
			e.printStackTrace();
		} finally {
			socketClose();
		}
	}
	public void socketClose() {
		try{
			if(ips != null){
				ips.close();
				ips = null;
			}
			if(socket != null && !socket.isClosed()){
				socket.close();
				socket = null;
			}
			if(ops != null) {
				ops.close();
				ops = null;
			}
		}
		catch(IOException e){
			e.printStackTrace();
		}
	}


}
